# delimit ;  
set more 1 ;  
local UNIX 0;
capture log close;
drop _all;
clear all;
capture log close;
*set maxvar 32000;
set mem 1000m;

global folder "C:\Dropbox";
*global folder "C:\Users\Eric\Dropbox\";
*global folder "C:\Users\Ali\Documents";
*global folder "C:\Users\uctpkp0\Desktop";

*global folder "C:\research";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";




         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";

         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";
		 
*recode asset and health insurance data;
log using "`saved'merge6.log", replace ;
use "`saved'merge5";
gen long hhidpn=HHID;
replace hhidpn=hhidpn*1000+PN;
rename hhidpn indnum;

/*
sort HHID PN realyear;
replace nhnbw=nhnbw[_n-1] if nhnbw==. & assets~=. & HHID==HHID[_n-1] & PN==PN[_n-1];
sum assets nhnbw;
replace assets=nhnbw;
*/


sort wave;
by wave: sum pen* ten* if wave<=13;

* Recode missing pension variables;
gen same=.;
replace same=same1 if wave==1;
replace same=same2 if wave==2;
replace same=same3 if wave==3;
replace same=same4 if wave==4;
replace same=same5 if wave==5;
replace same=same6 if wave==6;
replace same=same7 if wave==7;
replace same=same8 if wave==8;
replace same=same9 if wave==9;
replace same=same10 if wave==10;
replace same=same11 if wave==11;
replace same=same12 if wave==12;
replace same=same13 if wave==13;


sort HHID PN wave;
* this may not be cautious enough, because people can switch jobs;
replace pennage=pennage[_n-1] if pennage==. & HHID==HHID[_n-1] & PN==PN[_n-1] & lfpr==1 & same~=0 & wave<=13;
replace peneage=peneage[_n-1] if peneage==. & HHID==HHID[_n-1] & PN==PN[_n-1] & lfpr==1 & same~=0 & wave<=13;

replace penDBlast=penDBlast[_n-1] if penDBlast==. & HHID==HHID[_n-1] & PN==PN[_n-1] & wave<=13;
replace penDBprev=penDBprev[_n-1] if penDBprev==. & HHID==HHID[_n-1] & PN==PN[_n-1] & wave<=13;

replace penDClast=penDClast[_n-1] if penDClast==. & HHID==HHID[_n-1] & PN==PN[_n-1] & wave<=13;
replace penDCprev=penDCprev[_n-1] if penDCprev==. & HHID==HHID[_n-1] & PN==PN[_n-1] & wave<=13;

replace tenurelast=tenurelast[_n-1] if tenurelast==. & HHID==HHID[_n-1] & PN==PN[_n-1] & wave<=13;
replace tenureprev=tenureprev[_n-1] if tenureprev==. & HHID==HHID[_n-1] & PN==PN[_n-1] & wave<=13;

sort wave;
by wave: sum pen* ten* if wave<=13;


******************************************;
*             code up the married variable;
sort indnum age ;
replace married=married[_n-1] if indnum==indnum[_n-1] & age<age[_n-1]+3 & married==.;
replace married=married[_n+1] if indnum==indnum[_n+1] & age>age[_n+1]-3 & married==.;
*gen one_m_age=1-age;
*sort one_m_age ;
*replace married=married[_n-1] if indnum==indnum[_n+1] & age<age[_n+1]-3 & married==.;

* need to settle on a "disability" measure;
*gen disabled=.;
*replace disabled= 1 if heal==5;
*replace disabled= 0 if heal>0 & heal<5;

** here's what it looks like for wave 5                         ;
*  r5dstat:w5 'position |                                       ;
*  1=dk, 2=ssdi, 3=ssi' |      Freq.     Percent        Cum.    ;
*-----------------------+-----------------------------------    ;
*         0.no activity |     18,110       92.50       92.50    ;
*        1.applying ssi |         11        0.06       92.55    ;
*       2.receiving ssi |        240        1.23       93.78    ;
*      10.applying ssdi |         84        0.43       94.21    ;
*11.applying ssdi + ssi |          3        0.02       94.22    ;
*12.apply ssdi/recv ssi |          5        0.03       94.25    ;
*     20.receiving ssdi |        622        3.18       97.43    ;
*21.recv ssdi/apply ssi |          1        0.01       97.43    ;
*    22.recv ssdi + ssi |         75        0.38       97.81    ;
* 100.applying dk which |        156        0.80       98.61    ;
*200.receiving dk which |        272        1.39      100.00    ;
*-----------------------+-----------------------------------    ;
*                 Total |     19,579      100.00                ;
tab disabled;

gen temp=disabled;
replace disabled =0 if (temp==1|temp==10 |temp==11|temp==100);
replace disabled =1 if (temp==2|temp==12|temp==20 |temp==21|temp==22|temp==200);

* make people in bad health if disabled;
replace heal=5 if disabled==1;

******************************************************;
*recode health insurance data**************************;

gen insmedcd=0; * Medicaid health insurance;
replace insmedcd=1 if insgov==2; 

* assume that VA\CHAMPUS is the same as eprhi;
replace eprhi=1 if insgov==1; * VA\CHAMPUS; 
replace epins=1 if insgov==1; * VA\CHAMPUS;
replace eprhi=1 if inssp==1;

*generate a variable for health insurance tied to your job;
gen instie=.;
replace instie=1 if epins==1 & eprhi==0 & inssp==0;
replace instie=0 if epins==0|eprhi==1|inssp==1;

replace inssp=0 if eprhi==1;
replace insgov=0 if epins==1|inspriv==1; * recall that insgov=1 is just for VA\CHAMPUS coverage, insgov=2 is for Medicaid coverage;

gen insnone=.;
replace insnone=1 if epins==0 & insgov==0;
replace insnone=0 if epins==1|insgov==1|inssp==1;
replace inspriv=0 if epins==1|insgov==1;

*replace insnone=1 if insmedcd==1;
*replace insnone=1 if inspriv==1;



* get rid of extraneous insurance variables;
drop epfr eprfr;

******************************************************;
*recode spouse's health insurance data**************************;

gen _insmedcd=0; * Medicaid health insurance;
replace _insmedcd=1 if _insgov==2; 

replace _eprhi=1 if _insgov==1; * VA\CHAMPUS;
replace _epins=1 if _insgov==1; * VA\CHAMPUS;

replace _eprhi=1 if _inssp==1;

*generate a variable for health insurance tied to your job;
gen _instie=.;
replace _instie=1 if _epins==1 & _eprhi==0 & _inssp==0;
replace _instie=0 if _epins==0|_eprhi==1|_inssp==1;

replace _inssp=0 if _eprhi==1;
replace _insgov=0 if _epins==1|_inspriv==1; * recall that insgov=1 is just for VA\CHAMPUS coverage, insgov2 is for Medicaid coverage;

gen _insnone=.;
replace _insnone=1 if _epins==0 & _insgov==0;
replace _insnone=0 if _epins==1|_insgov==1|_inssp==1;
replace _inspriv=0 if _epins==1|_insgov==1;

*replace _insnone=1 if _insmedcd==1;
*replace _insnone=1 if _inspriv==1;



* generate wave 1 labor force participation and wage****************;

gen lfprw1=lfpr if wave==1;
replace lfprw1=lfpr if wave==2 & lfprw1==.;
replace lfprw1=lfpr if wave==3 & lfprw1==.;
replace lfprw1=lfpr if wave==4 & lfprw1==.;
replace lfprw1=lfpr if wave==5 & lfprw1==.;
replace lfprw1=lfpr if wave==6 & lfprw1==.;
replace lfprw1=lfpr if wave==7 & lfprw1==.;
replace lfprw1=lfpr if wave==8 & lfprw1==.;
replace lfprw1=lfpr if wave==9 & lfprw1==.;
replace lfprw1=lfpr if wave==10 & lfprw1==.;
replace lfprw1=lfpr if wave==11 & lfprw1==.;
replace lfprw1=lfpr if wave==12 & lfprw1==.;
replace lfprw1=lfpr if wave==13 & lfprw1==.;
sort HHID PN realyear;
replace lfprw1=lfprw1[_n-1] if lfprw1[_n-1]~=. & HHID==HHID[_n-1] & PN==PN[_n-1];

gen wagew1=wage if wave==1;
replace wagew1=wage if wave==2 & wagew1==.;
replace wagew1=wagelast if wave==1 & wagew1==.;
replace wagew1=wage if wave==3 & wagew1==.;
replace wagew1=wage if wave==4 & wagew1==.;
replace wagew1=wage if wave==5 & wagew1==.;
replace wagew1=wage if wave==6 & wagew1==.;
replace wagew1=wage if wave==7 & wagew1==.;
replace wagew1=wage if wave==8 & wagew1==.;
replace wagew1=wage if wave==9 & wagew1==.;
replace wagew1=wage if wave==10 & wagew1==.;
replace wagew1=wage if wave==11 & wagew1==.;
replace wagew1=wage if wave==12 & wagew1==.;
replace wagew1=wage if wave==13 & wagew1==.;
sort HHID PN realyear;
replace wagew1=wagew1[_n-1] if wagew1[_n-1]~=. & HHID==HHID[_n-1] & PN==PN[_n-1];

gen eprhiw1=eprhi if wave==1;
replace eprhiw1=eprhi if wave==2 & eprhiw1==.;
replace eprhiw1=eprhi if wave==3 & eprhiw1==.;
replace eprhiw1=eprhi if wave==4 & eprhiw1==.;
replace eprhiw1=eprhi if wave==5 & eprhiw1==.;
replace eprhiw1=eprhi if wave==6 & eprhiw1==.;
replace eprhiw1=eprhi if wave==7 & eprhiw1==.;
replace eprhiw1=eprhi if wave==8 & eprhiw1==.;
replace eprhiw1=eprhi if wave==9 & eprhiw1==.;
replace eprhiw1=eprhi if wave==10 & eprhiw1==.;
replace eprhiw1=eprhi if wave==11 & eprhiw1==.;
replace eprhiw1=eprhi if wave==12 & eprhiw1==.;
replace eprhiw1=eprhi if wave==13 & eprhiw1==.;
sort HHID PN realyear;
replace eprhiw1=eprhiw1[_n-1] if eprhiw1[_n-1]~=. & HHID==HHID[_n-1] & PN==PN[_n-1];

gen instiew1=instie if wave==1;
replace instiew1=instie if wave==2 & instiew1==.;
replace instiew1=instie if wave==3 & instiew1==.;
replace instiew1=instie if wave==4 & instiew1==.;
replace instiew1=instie if wave==5 & instiew1==.;
replace instiew1=instie if wave==6 & instiew1==.;
replace instiew1=instie if wave==7 & instiew1==.;
replace instiew1=instie if wave==8 & instiew1==.;
replace instiew1=instie if wave==9 & instiew1==.;
replace instiew1=instie if wave==10 & instiew1==.;
replace instiew1=instie if wave==11 & instiew1==.;
replace instiew1=instie if wave==12 & instiew1==.;
replace instiew1=instie if wave==13 & instiew1==.;
sort HHID PN realyear;
replace instiew1=instiew1[_n-1] if instiew1[_n-1]~=. & HHID==HHID[_n-1] & PN==PN[_n-1];

gen inspriv1=inspriv if wave==1;
replace inspriv1=inspriv if wave==2 & inspriv1==.;
replace inspriv1=inspriv if wave==3 & inspriv1==.;
replace inspriv1=inspriv if wave==4 & inspriv1==.;
replace inspriv1=inspriv if wave==5 & inspriv1==.;
replace inspriv1=inspriv if wave==6 & inspriv1==.;
replace inspriv1=inspriv if wave==7 & inspriv1==.;
replace inspriv1=inspriv if wave==8 & inspriv1==.;
replace inspriv1=inspriv if wave==9 & inspriv1==.;
replace inspriv1=inspriv if wave==10 & inspriv1==.;
replace inspriv1=inspriv if wave==11 & inspriv1==.;
replace inspriv1=inspriv if wave==12 & inspriv1==.;
replace inspriv1=inspriv if wave==13 & inspriv1==.;
sort HHID PN realyear;
replace inspriv1=inspriv1[_n-1] if inspriv1[_n-1]~=. & HHID==HHID[_n-1] & PN==PN[_n-1];




***********************************;
/* 
for the preference heterogeneity cases, there are 3 important cases:
1: lfpr in wave 1=0 => V3319=0, V5009=0
2: lfpr in wave 1=1 => V3319>0, V5009=0 (I will never retire guys)
3: lfpr in wave 1=1 => V3319>0, V5009>0 
*/

* for most of the variables, higher numbers implies greater preference for work, but not all variables;
* make it so that for all variables, higher numbers implies greater preference for work;
replace V5018=5-V5018;
replace V5019=5-V5019;
replace V3319=5-V3319;
replace V3319=0 if V3319==5;

* for most observations, zeros/missing means that they did not work or it was a proxy interview;
* however, the ones below had zeros for reasons like being unmarried (and I want to keep those people);
replace V3319=0 if lfprw1==0;
gen V3319zero=0;
replace V3319zero = 1 if (V3319 == 0|V3319==.);
replace V3319=0 if V3319zero==1;

tab V3319zero lfprw1;
tab V3319zero lfpr if realyear>97;

* below is a good variable, but it is not used for the most part;
replace V9063=0 if V3319==0;
gen V9063zero=0;
replace V9063zero = 1 if (V9063 == 98| V9063==99 |V9063==.|V9063==0);
replace V9063=0 if V9063zero==1;
gen V9063miss=0;
replace V9063miss=1 if V3319zero==0 & V9063zero==1;

replace V5009=0 if V3319==0;
gen V5009zero=0;
replace V5009zero = 1 if (V5009 == 0|V5009==.);
replace V5009=0 if V5009zero==1;
gen V5009miss=0;
replace V5009miss=1 if V3319zero==0 & V5009zero==1;


*generate a single health variable;
gen healw=0;
replace healw=1 if heal==4|heal==5|dead==1;

tab hrscoh;





gen age1= age;
drop if age<46;
drop if male~=1;
replace heal=5 if dead==1;
replace lfpr=0 if dead==1;


***********begin drop criteria for different age groups **********;
gen ageg=0;
replace ageg=1 if male==1 & hrscoh==1 & dead~=1 & birthyr>1930 & birthyr<1936 & age>50 & age<70;
replace ageg=2 if male==1 & hrscoh==1 & dead~=1 & birthyr>1935 & birthyr<1942 & age>50 & age<70;;


tab hrscoh;

**********now we drop people *************;
************this lfpr criteria needs to be commented out for the med ex stuff, but these are the relevant criteria for the sample described in Appendix G;
*sort ageg;
*by ageg: sum lfpr healw;
*drop if lfpr==.;

sort ageg;
by ageg: sum lfpr healw;
drop if SScov==1 & SSYears>10;


tab hrscoh;

sort ageg;
by ageg: sum lfpr lfprz;
drop if lfprw1==.;
tab hrscoh;
drop if (heal==.|heal==8|heal==9); 

bysort indnum (age): gen initobs=_n==1;




sort ageg;
by ageg: sum lfpr;
sort wave;
by wave: sum lfpr if ageg==1;
by wave: sum lfpr if ageg==2;

tab hrscoh;


* Recode hours data;
replace hours=0 if hours<300 & hours~=.;
gen lhours=ln(hours);
replace lhours=. if wave>30; * make hours missing for "fake" waves; 

sum *rLABY *socy *peny;


*wife's income here;
rename _rLABY winc; * just keep with the PSID variable definition;
sort married;
sum winc;
replace winc=0 if winc==. & married~=.;
replace _socy=0 if _socy==. & married~=.;
replace _peny=0 if _peny==. & married~=.;
replace winc=winc+_socy+_peny;
replace winc=0 if married==0;
sum winc;
replace winc=. if wave>20; * make =. for fake waves;
gen spouseworker =0;
replace spouseworker=1 if winc>=2000 & winc<1000000;
sum winc;


tab married spouseworker, m;



replace _oopd=0 if _oopd==.;
gen oopd_hh=oopd+_oopd;
replace oopd_hh=. if oopd_hh>200000 & oopd_hh~=.;


* insurance premia (including part B) here;
replace _iprem_b=0 if _iprem_b==.;
gen iprem_b_hh=iprem_b+_iprem_b;
replace iprem_b_hh=. if iprem_b_hh>50000 & iprem_b_hh~=.;
gen iprem_hh=iprem +_iprem;

*       ----- fixing privately insured guys that don't pay premium -----;
replace inspriv     =1 if iprem_hh>=100 & inspriv==0 & epins==0;
replace insnone     =0 if (inspriv==1|medicaid==1);

* replace epins       =0 if epins==1 & iprem_hh<1000;
replace inspriv     =0 if inspriv==1 & iprem_hh<100;
replace inspriv     =1 if insexch==1;
replace insnone     =1 if inspriv==0 & epins==0 & medicaid==0 & medcare==0;
*       ----------------------------------------------------------------;



save "`saved'merge6", replace;

drop _all;
log close ;












